<?php

$this->pageTitle = 'Zlecenia - ' . Yii::app()->name;

$this->breadcrumbs = array(
	'Zlecenia'
);

?>
<h1>Zlecenia</h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('create') ?>">Dodaj nowe zlecenie</a> |
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('import') ?>">Importuj zlecenia</a> |
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('balance') ?>">Zmień wagi cen zleceń</a> |
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('solutions') ?>">Zarządzaj rozwiązanymi zleceniami</a>

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'zlecenie-grid',
	'dataProvider'=>$model->search(),
	'htmlOptions' => array('class' => 'tDefault'),
	'filter'=>$model,
	'columns'=>array(
		'id',
		array(
				'name'=>'idDziedziny',
				'type'=>'raw',
				'value'=>'$data->dziedzina->nazwa',
		),
		array(
				'name'=>'poziom',
				'type'=>'raw',
				'value'=>'$data->poziomStr',
		),
		'kategoria',
		array(
				'name'=>'czas',
				'type'=>'raw',
				'value'=>'sprintf(\'%02d:%02d:%02d\', (int)$data->czas/3600, (int)($data->czas)/60 % 60, (int)$data->czas%60)',
		),
		array(
			'name' => 'cena',
			'type' => 'raw',
			'value' => 'number_format($data->cena,2,\'.\',\' \').\'\''
		),
		array(
			'class'=>'CButtonColumn',
		),
	),
));

?>
